#ifndef ISING_H
#define ISING_H

#include <cmath>
#include <cstdlib>
#include <random>
#include <iostream>
#include <mpi.h>

class Ising
{

 public:
  Ising(double beta, double B, double J, unsigned int Nx, unsigned int Ny, std::string hc, int size):
  m_beta(beta), mB(B), mJ(J), m_Nx(Nx), m_Ny(Ny)//Konstruktor
  {
    mgrid = (int*)realloc(mgrid, sizeof(int)*(m_Nx*m_Ny/size/size + 2*(m_Nx+m_Ny)/size + 4));
    if(hc == "hot_start" )  hot_start(); //defines grid containing spins
    if(hc == "cold_start") cold_start();
  };

  ~Ising() {delete mgrid;};
  

  //functions
  void cold_start();
  void  hot_start();
  
  double compute_energy();
  double delta_energy(int, int);
  
  void MC_sweep();
  
  void production_run(unsigned int);

  int compute_spin(int grid_point) const {return mgrid[grid_point];};
  
  std::vector<double> energies;

  
  
 private:
  double m_beta;
  double mB;
  double mJ;
  double mE;
  unsigned int m_Nx;
  unsigned int m_Ny;
  
  int *mgrid=NULL;
  
};

#endif
